// MSR_SOIMPL : Implementation of TMSR_SOImpl (CoClass: MSR_SO, Interface: IMSR_SO)


#include <vcl.h>
#pragma hdrstop

#include "MSR_SOIMPL.H"
#include "InitTime.h"
#include "HealthResult.h"

#define debugmode 1

int InitTimeValue;
int tEndStatus=0;
int ttEndStatus=0;
bool isDebug = false;
long mOTime=0;
long dTime=0;
AnsiString aat;
char att[50];
static HINSTANCE hDllInst=NULL;
static bool HookOnOff=false;
static TMSR_SOImpl *SOInstance;      //SO
static IDispatch *CODispatch;        //CO

bool (__stdcall *EnableKeyboardCapture)();
bool (__stdcall *DisableKeyboardCapture)();

void SendStatusMessage()
{
    HWND hWnd=FindWindow(NULL, "ReceiveForm");
    if (hWnd)
    {
        COPYDATASTRUCT CopyData;
        CopyData.dwData=0;
        CopyData.cbData=sizeof(OPOSStruct);
        CopyData.lpData=&ms;

        SendMessage(hWnd, WM_COPYDATA, (WPARAM)NULL, (LPARAM)&CopyData);
    }
}

void  ShowAbout()     //CheckHealth INTERACTIVE
{
    frmAbout  = new TfrmAbout(Application);
    frmAbout->ShowModal();
    delete frmAbout ;
}

void __fastcall ShowHealthResult(WideString tmpTrack1,WideString tmpTrack2,WideString tmpTrack3,WideString tmpTrack4,WideString testStatus )
{

    frmHealthResult  = new TfrmHealthResult(Application);

    frmHealthResult->lblStatus->Caption =  AnsiString(testStatus);
    frmHealthResult->lblTrack1Data->Caption = AnsiString(tmpTrack1);
    frmHealthResult->lblTrack2Data->Caption = AnsiString(tmpTrack2);
    frmHealthResult->lblTrack3Data->Caption = AnsiString(tmpTrack3);
    frmHealthResult->lblTrack4Data->Caption = AnsiString(tmpTrack4);

    frmHealthResult->ShowModal();

    delete frmHealthResult;
}

#pragma package(smart_init)


/////////////////////////////////////////////////////////////////////////////
// TMSR_SOImpl

STDMETHODIMP TMSR_SOImpl::CheckHealth(long Level, long* pRC)
{
    if (m_State==OPOS_S_CLOSED)
    {
        m_ResultCode=OPOS_E_CLOSED;
        *pRC=m_ResultCode;

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Error::Device Closed!!");
#endif

        return S_OK;
    }
    if (m_DeviceEnabled!=true)
    {
        m_ResultCode=OPOS_E_DISABLED;
        *pRC=m_ResultCode;

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Error::Device is Disable!!");
#endif

        return S_OK;
    }
    if (m_Claimed !=true)
    {
        m_ResultCode=OPOS_E_NOTCLAIMED;
        *pRC=m_ResultCode;

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Error::Device not Claim!!");
#endif

        return S_OK;
    }
    switch (Level)
    {
    case OPOS_CH_INTERNAL:
        WaitForSingleObject(IORWMutex,INFINITE);
        m_CheckHealthText=WideString("Check Health Internal : Success");
        m_ResultCode=OPOS_SUCCESS;
        ReleaseMutex(IORWMutex);

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Status::Check internal health success");
#endif

        break;
    case OPOS_CH_EXTERNAL:
        WaitForSingleObject(IORWMutex,INFINITE);
        m_CheckHealthText=WideString("Check Health External : Success");
        m_ResultCode=OPOS_SUCCESS;
        ReleaseMutex(IORWMutex);

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Status::Check external health success");
#endif

        break;
    case OPOS_CH_INTERACTIVE:
#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Status::Check interactive health start");
#endif

#ifdef debugmode
        if (isDebug==true)
        {
            OutputDebugString("CheckHealth Status::Get initial time success");
            aat = "CheckHealth Status:: Initial time = " + IntToStr(InitTimeValue);
            OutputDebugString(aat.c_str());
        }
#endif
        //=======================================
        WaitForSingleObject(DllDataAvailable,INFINITE);
        HANDLE hShareMemory;
        LPVOID lpShareMemoryAddress;
        MSRData *MyData;
        hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                       NULL,
                                       PAGE_READWRITE,
                                       0,
                                       2048,
                                       "MSRData");
        lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                           FILE_MAP_READ|FILE_MAP_WRITE,
                                           0,
                                           0,
                                           sizeof(MSRData));
        MyData=(MSRData *)lpShareMemoryAddress;

        memset(MyData->MSRTrack1Data ,0,256);
        memset(MyData->MSRTrack2Data ,0,256);
        memset(MyData->MSRTrack3Data ,0,256);
        memset(MyData->MSRTrack4Data ,0,256);

        UnmapViewOfFile(lpShareMemoryAddress);
        CloseHandle(hShareMemory);

        m_Track1Data.Empty();
        m_Track2Data.Empty();
        m_Track3Data.Empty();
        m_Track4Data.Empty();
        m_AccountNumber.Empty();
        m_ExpirationDate.Empty();
        m_Title.Empty();
        m_FirstName.Empty();
        m_MiddleInitial.Empty();
        m_Surname.Empty();
        m_Suffix.Empty();
        m_ServiceCode.Empty();
        m_Track1DiscretionaryData.Empty();
        m_Track2DiscretionaryData.Empty();

        memset(m_Track1DataMatrix,0,128);
        memset(m_Track2DataMatrix,0,128);
        memset(m_Track3DataMatrix,0,128);
        memset(m_Track4DataMatrix,0,128);

        memset(m_AccountNumberMatrix,0,128);
        memset(m_ExpirationDateMatrix,0,4);// length shold be 4
        memset(m_TitleMatrix,0,128);
        memset(m_FirstNameMatrix,0,64);
        memset(m_MiddleInitialMatrix,0,64);
        memset(m_SurnameMatrix,0,64);
        memset(m_SuffixMatrix,0,64);
        memset(m_ServiceCodeMatrix,0,10); //length should be 3
        memset(m_Track1DiscretionaryDataMatrix,0,128);
        memset(m_Track2DiscretionaryDataMatrix,0,128);

        ReleaseMutex(DllDataAvailable);

        int EndStatus=0;
        tEndStatus=0;
        long StartTime;

        ShowAbout();

        if (InitTimeValue < 0)
        {
            m_ResultCode=OPOS_SUCCESS;
            *pRC=m_ResultCode;
#ifdef debugmode
            if (isDebug==true)
                OutputDebugString("CheckHealth Error::Get initial time fail!!");
#endif
            return S_OK;
        }

        StartTime=GetTickCount();
        do
        {
            Application->ProcessMessages();

            EndStatus = tEndStatus;
            if (EndStatus!=0)
            {
#ifdef debugmode
                if (isDebug==true)
                {
                    aat = "CheckHealth Status::End track is TRACK" + IntToStr(EndStatus) ;
                    OutputDebugString(aat.c_str());
                }
#endif
                bool TrackS=false;
                do
                {
                    Application->ProcessMessages();
                    switch (EndStatus)
                    {
                    case 1:
                        if (m_Track1DataMatrix)
                            TrackS=true;
                        break;
                    case 2:
                        if (m_Track2DataMatrix)
                            TrackS=true;
                        break;
                    case 3:
                        if (m_Track3DataMatrix)
                            TrackS=true;
                        break;
                    case 4:
                        if (m_Track4DataMatrix)
                            TrackS=true;
                        break;
                    default:
                        TrackS=false;
                    }
                }
                while (TrackS==false);
                m_CheckHealthText=WideString("Check Health Interactive : Success");
                ShowHealthResult(m_Track1DataMatrix,m_Track2DataMatrix,m_Track3DataMatrix,m_Track4DataMatrix,m_CheckHealthText);
                InitTimeValue=0;
                m_ResultCode=OPOS_SUCCESS;
                *pRC=m_ResultCode;

#ifdef debugmode
                if (isDebug==true)
                {
                    OutputDebugString("CheckHealth Status::Check interactive health success");
                    aat =  "CheckHealth Status::Track1 = " + AnsiString(m_Track1DataMatrix);
                    OutputDebugString(aat.c_str());
                    aat =  "CheckHealth Status::Track2 = " + AnsiString(m_Track2DataMatrix);
                    OutputDebugString(aat.c_str());
                    aat =  "CheckHealth Status::Track3 = " + AnsiString(m_Track3DataMatrix);
                    OutputDebugString(aat.c_str());
                    aat =  "CheckHealth Status::Track4 = " + AnsiString(m_Track4DataMatrix);
                    OutputDebugString(aat.c_str());
                }
#endif
                return S_OK;
            }
        }
        while ((GetTickCount()-StartTime)<=InitTimeValue);
        m_CheckHealthText=WideString("Check Health Interactive : Timed out");
        ShowHealthResult(m_Track1DataMatrix,m_Track2DataMatrix,m_Track3DataMatrix,m_Track4DataMatrix,m_CheckHealthText);
        m_ResultCode=OPOS_E_TIMEOUT;
        InitTimeValue=0;

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("CheckHealth Error::Check interactive health timeout!!");
#endif
    }
    *pRC=m_ResultCode;
    return S_OK;
}


STDMETHODIMP TMSR_SOImpl::Claim(long Timeout, long* pRC)
{
    if (Timeout<-1)
    {
        m_ResultCode=OPOS_E_ILLEGAL;
        *pRC=m_ResultCode;
        return S_OK;
    }
    HANDLE hShareMemory;
    LPVOID lpShareMemoryAddress;
    SMData *MyData;
    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   1024,
                                   "MSRSM");
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ | FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(SMData));
    MyData=(SMData *)lpShareMemoryAddress;
    HANDLE TempCM=OpenMutex(MUTEX_ALL_ACCESS | SYNCHRONIZE,true,"MSRCM");
    HANDLE TempRE=OpenEvent(EVENT_ALL_ACCESS,true,"MSRRE");
    //wait to use share memory
    WaitForSingleObject(TempCM,INFINITE);
    if (Timeout==OPOS_FOREVER)
    {
        WaitForSingleObject(TempRE,INFINITE);
    }

    if ((Timeout!=0) && (Timeout !=OPOS_FOREVER))
    {
        if (WaitForSingleObject(TempRE,Timeout)==WAIT_TIMEOUT)
        {
            ReleaseMutex(TempCM);
            UnmapViewOfFile(lpShareMemoryAddress);
            CloseHandle(hShareMemory);
            CloseHandle(TempCM);
            CloseHandle(TempRE);
            m_ResultCode=OPOS_E_TIMEOUT;
            *pRC=m_ResultCode;
            return S_OK;
        }
    }
    // if allow to access but some one use before
    if (MyData->ClaimedFlag==true)
    {
        ReleaseMutex(TempCM);
        UnmapViewOfFile(lpShareMemoryAddress);
        CloseHandle(hShareMemory);
        CloseHandle(TempCM);
        CloseHandle(TempRE);
        m_ResultCode=OPOS_E_ILLEGAL;
        *pRC=m_ResultCode;
        return S_OK;
    }
    MyData->ClaimedFlag =true;

    UnmapViewOfFile(lpShareMemoryAddress);
    CloseHandle(hShareMemory);
    ReleaseMutex(TempCM);
    ResetEvent(TempRE);
    CloseHandle(TempCM);
    CloseHandle(TempRE);
    // load dll file here
    // because use the same filemapping ..
    // so you need to close all handle about filemapping here
    // and start to load dll (it will load file mapping again)
    // you can modify the hook dll not to load filemapping
    // and it will be better here
    //ShowMessage("Start to load functions");
    //LPVOID lpMsgBuf;
    char mpathstr[256];
    char mpath[256];
    memset(mpathstr,0,256);
    memset(mpath,0,256);
    GetSystemDirectory(mpath,256);

    sprintf(mpathstr,"%s\\KBhook.dll",mpath);
    hDllInst=LoadLibrary(mpathstr);
    Sleep(300);
    if (!hDllInst)
    {
        m_ResultCodeExtended=1110;
        m_ResultCode=OPOS_E_NOSERVICE;
        *pRC=m_ResultCode;
        return S_OK;
    }
    EnableKeyboardCapture=(bool (__stdcall *)())GetProcAddress(hDllInst,"EnableKeyboardCapture");
    DisableKeyboardCapture=(bool (__stdcall*)())GetProcAddress(hDllInst,"DisableKeyboardCapture");
    mGetDataCheck=0;
    m_Claimed=true;
    m_ResultCode=OPOS_SUCCESS;
    *pRC=m_ResultCode;

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::ClaimDevice(long Timeout, long* pRC)
{
#ifdef debugmode
    if (isDebug==true)
        OutputDebugString("ClaimDevice Status::Claim device start");
#endif
    if (Timeout<-1)
    {
        m_ResultCode=OPOS_E_ILLEGAL;
        *pRC=m_ResultCode;

#ifdef debugmode
        if (isDebug==true)
            OutputDebugString("ClaimDevice Error::Claim timeout value fail!!");
#endif
        return S_OK;
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ClaimDevice Status::Claim timeout =" + IntToStr((int)Timeout) ;
        OutputDebugString(aat.c_str());
    }
#endif
    HANDLE hShareMemory;
    LPVOID lpShareMemoryAddress;
    SMData *MyData;
    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   1024,
                                   "MSRSM");
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ | FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(SMData));
    MyData=(SMData *)lpShareMemoryAddress;



    HANDLE TempCM=OpenMutex(MUTEX_ALL_ACCESS | SYNCHRONIZE,true,"MSRCM");
    HANDLE TempRE=OpenEvent(EVENT_ALL_ACCESS,true,"MSRRE");
    //wait to use share memory
    WaitForSingleObject(TempCM,INFINITE);
    if (Timeout==OPOS_FOREVER)
    {
        WaitForSingleObject(TempRE,INFINITE);
    }

    if ((Timeout!=0) && (Timeout !=OPOS_FOREVER))
    {
        if (WaitForSingleObject(TempRE,Timeout)==WAIT_TIMEOUT)
        {
            ReleaseMutex(TempCM);
            UnmapViewOfFile(lpShareMemoryAddress);
            CloseHandle(hShareMemory);
            CloseHandle(TempCM);
            CloseHandle(TempRE);
            m_ResultCode=OPOS_E_TIMEOUT;
            *pRC=m_ResultCode;

#ifdef debugmode
            if (isDebug==true)
            {
                aat = "ClaimDevice Error::Claim device timeout!!" ;
                OutputDebugString(aat.c_str());
            }
#endif
            return S_OK;
        }
    }
    // if allow to access but some one use before
    if (MyData->ClaimedFlag==true)
    {
        ReleaseMutex(TempCM);
        UnmapViewOfFile(lpShareMemoryAddress);
        CloseHandle(hShareMemory);
        CloseHandle(TempCM);
        CloseHandle(TempRE);
        m_ResultCode=OPOS_E_ILLEGAL;
        *pRC=m_ResultCode;
        return S_OK;
    }
    MyData->ClaimedFlag =true;

    UnmapViewOfFile(lpShareMemoryAddress);
    CloseHandle(hShareMemory);

    // load dll file here
    // because use the same filemapping ..
    // so you need to close all handle about filemapping here
    // and start to load dll (it will load file mapping again)
    // you can modify the hook dll not to load filemapping
    // and it will be better here

    //LPVOID lpMsgBuf;
    char mpathstr[256];
    char mpath[256];
    memset(mpathstr,0,256);
    memset(mpath,0,256);
    GetSystemDirectory(mpath,256);

    sprintf(mpathstr,"%s\\KBhook.dll",mpath);
    hDllInst=LoadLibrary(mpathstr);
    if (!hDllInst)
    {
        m_ResultCodeExtended=1110;
        m_ResultCode=OPOS_E_NOSERVICE;
        *pRC=m_ResultCode;
#ifdef debugmode
        if (isDebug==true)
        {
            aat = "ClaimDevice Error::Load " + AnsiString(mpathstr) + " laibrary fail!!" ;
            OutputDebugString(aat.c_str());
        }
#endif
        return S_OK;
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ClaimDevice Status::Load " + AnsiString(mpathstr) + " library success" ;
        OutputDebugString(aat.c_str());
    }
#endif

    EnableKeyboardCapture=(bool (__stdcall *)())GetProcAddress(hDllInst,"EnableKeyboardCapture");
    DisableKeyboardCapture=(bool (__stdcall*)())GetProcAddress(hDllInst,"DisableKeyboardCapture");
    mGetDataCheck=0;
    ReleaseMutex(TempCM);
    ResetEvent(TempRE);
    CloseHandle(TempCM);
    CloseHandle(TempRE);
    m_Claimed=true;
    m_ResultCode=OPOS_SUCCESS;
    *pRC=m_ResultCode;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ClaimDevice Status::Claim device success" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::ClearInput(long* pRC)
{
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ClearInput Status::Clear input start" ;
        OutputDebugString(aat.c_str());
    }
#endif
    if (m_State==OPOS_S_CLOSED)
    {
        m_ResultCode=OPOS_E_CLOSED;
        *pRC=m_ResultCode;
#ifdef debugmode
        if (isDebug==true)
        {
            aat = "ClearInput Error::Device closed!!" ;
            OutputDebugString(aat.c_str());
        }
#endif

        return S_OK;
    }
    if (m_Claimed !=true)
    {
        m_ResultCode=OPOS_E_NOTCLAIMED;
        *pRC=m_ResultCode;
#ifdef debugmode
        if (isDebug==true)
        {
            aat = "ClearInput Error::Device not claim!!" ;
            OutputDebugString(aat.c_str());
        }
#endif

        return S_OK;
    }

    WaitForSingleObject(DllDataAvailable,INFINITE);
    HANDLE hShareMemory;
    LPVOID lpShareMemoryAddress;
    MSRData *MyData;
    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   2048,
                                   "MSRData");
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ|FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(MSRData));
    MyData=(MSRData *)lpShareMemoryAddress;

    memset(MyData->MSRTrack1Data ,0,256);
    memset(MyData->MSRTrack2Data ,0,256);
    memset(MyData->MSRTrack3Data ,0,256);
    memset(MyData->MSRTrack4Data ,0,256);



    m_Track1Data.Empty();
    m_Track2Data.Empty();
    m_Track3Data.Empty();
    m_Track4Data.Empty();
    m_AccountNumber.Empty();
    m_ExpirationDate.Empty();
    m_Title.Empty();
    m_FirstName.Empty();
    m_MiddleInitial.Empty();
    m_Surname.Empty();
    m_Suffix.Empty();
    m_ServiceCode.Empty();
    m_Track1DiscretionaryData.Empty();
    m_Track2DiscretionaryData.Empty();

    memset(m_Track1DataMatrix,0,128);
    memset(m_Track2DataMatrix,0,128);
    memset(m_Track3DataMatrix,0,128);
    memset(m_Track4DataMatrix,0,128);

    memset(t_Track1DataMatrix,0,128);
    memset(t_Track2DataMatrix,0,128);
    memset(t_Track3DataMatrix,0,128);
    memset(t_Track4DataMatrix,0,128);
    memset(t_AccountNumberMatrix,0,128);
    memset(t_ExpirationDateMatrix,0,4);// length shold be 4
    memset(t_TitleMatrix,0,128);
    memset(t_FirstNameMatrix,0,64);
    memset(t_MiddleInitialMatrix,0,64);
    memset(t_SurnameMatrix,0,64);
    memset(t_SuffixMatrix,0,64);
    memset(t_ServiceCodeMatrix,0,10); //length should be 3
    memset(t_Track1DiscretionaryDataMatrix,0,128);
    memset(t_Track2DiscretionaryDataMatrix,0,128);

    memset(m_AccountNumberMatrix,0,128);
    memset(m_ExpirationDateMatrix,0,4);// length shold be 4
    memset(m_TitleMatrix,0,128);
    memset(m_FirstNameMatrix,0,64);
    memset(m_MiddleInitialMatrix,0,64);
    memset(m_SurnameMatrix,0,64);
    memset(m_SuffixMatrix,0,64);
    memset(m_ServiceCodeMatrix,0,10); //length should be 3
    memset(m_Track1DiscretionaryDataMatrix,0,128);
    memset(m_Track2DiscretionaryDataMatrix,0,128);

    ReleaseMutex(DllDataAvailable);
    m_ResultCode=OPOS_SUCCESS;
    *pRC=m_ResultCode;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ClearInput Status::Clear input success" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::ClearOutput(long* pRC)
{
    m_ResultCode=OPOS_E_ILLEGAL;
    *pRC=m_ResultCode;
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ClearOutput Error::No support this function" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::Close(long* pRC)
{
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "Close Status::Close start" ;
        OutputDebugString(aat.c_str());
    }
#endif
    if (m_Claimed == true)
    {
        long TempRC=0;
        ReleaseDevice(&TempRC);
    }
    EventThread->Terminate();
    CloseHandle(EventThread);
    SetEvent(EventThreadActive);
    mTimer->Resume();
    mOTimer->Resume();
    mOTimer->Terminate();
    mTimer->Terminate();
    CloseHandle(mOTimer);
    CloseHandle(mTimer);
    mDataEndThread->Resume();
    mDataEndThread->Terminate();
    CloseHandle(mDataEndThread);
    SetEvent(FreezeEventsUnfrozen);
    SetEvent(COFreezeEventsUnfrozen);
    SetEvent(DataEventEnable);

    HANDLE ObjectHandles[2]={EventThreadTerminated,//DllGetTrackDataEventTerminated,
                             EnableDllDataEventTerminated};
    WaitForMultipleObjects(2,ObjectHandles,true,INFINITE);

    CloseHandle(IORWMutex);
    CloseHandle(m_EventQueueAvailable);
    CloseHandle(EventThreadActive);
    CloseHandle(EventThreadTerminated);
    CloseHandle(FreezeEventsUnfrozen);
    CloseHandle(COFreezeEventsUnfrozen);
    CloseHandle(DllDataAvailable);
    CloseHandle(EventTimeOut);
    CloseHandle(TimerActive);

    CloseHandle(DataEventEnable);
    CloseHandle(mIORWMutex);
    CloseHandle(EnableDllDataEvent);  // for process dll data event thread
    CloseHandle(DisableDllDataEvent); // for process dll share memory data thread
    CloseHandle(EnableDllDataEventTerminated);
    m_State=OPOS_S_CLOSED;
    *pRC=OPOS_SUCCESS;
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "Close Status::Close success" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

//
STDMETHODIMP TMSR_SOImpl::COFreezeEvents(TOLEBOOL Freeze, long* pRC)
{
    if (Freeze==false)
        SetEvent(COFreezeEventsUnfrozen);
    else
        ResetEvent(COFreezeEventsUnfrozen);

    m_ResultCode=OPOS_SUCCESS;
    *pRC=m_ResultCode;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "FreezeEvents Status::FreezeEvent success" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::DirectIO(long Command, long* pData,
                                   BSTR* pString, long* pRC)
{
    m_ResultCode=OPOS_E_NOSERVICE;
    *pRC=m_ResultCode;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "DirectIO Error::No support this function!!" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::GetOpenResult(long* pRC)
{
    m_ResultCode=OPOS_E_NOSERVICE;
    *pRC=m_ResultCode;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "GetOpenResult Error::No support this function!!" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::GetPropertyNumber(long PropIndex,
        long* pNumber)
{
    switch (PropIndex)
    {
    case PIDX_AutoDisable:
        *pNumber=m_AutoDisable;
        break;
    case PIDX_Claimed:
        *pNumber=m_Claimed;
        break;
    case PIDX_DeviceEnabled:
        *pNumber=m_DeviceEnabled;
        break;
    case PIDX_FreezeEvents:
        *pNumber=m_FreezeEvents;
        break;
    case PIDX_ResultCode:
        *pNumber=m_ResultCode;
        break;
    case PIDX_ResultCodeExtended:
        *pNumber=m_ResultCodeExtended;
        break;
    case PIDX_State:
        *pNumber=m_State;
        break;
    case PIDX_BinaryConversion:
        *pNumber=m_BinaryConversion;
        break;
    case PIDX_PowerNotify:
        *pNumber=m_PowerNotify;
        break;
    case PIDX_PowerState:
        *pNumber=m_PowerState;
        break;
    case PIDX_CapPowerReporting:
        *pNumber=m_CapPowerReporting;
        break;
    case PIDX_ServiceObjectVersion:
        *pNumber=SERVICEOBJECTVERSION;
        break;
    case PIDX_DataCount:
        *pNumber=m_DataCount;
        break;
    case PIDX_DataEventEnabled:
        *pNumber=m_DataEventEnabled;
        break;
    case PIDX_OutputID:
        *pNumber=m_OutputID;
        break;
    case PIDXMsr_CapISO:
        *pNumber=m_CapISO;
        break;
    case PIDXMsr_CapJISOne:
        *pNumber=m_CapJISOne;
        break;
    case PIDXMsr_CapJISTwo:
        *pNumber=m_CapJISTwo;
        break;
    case PIDXMsr_CapTransmitSentinels:
        *pNumber=m_CapTransmitSentinels;
        break;
    case PIDXMsr_TracksToRead:
        *pNumber=m_TracksToRead;
        break;
    case PIDXMsr_DecodeData:
        *pNumber=m_DecodeData;
        break;
    case PIDXMsr_ParseDecodeData:
        *pNumber=m_ParseDecodeData;
        break;
    case PIDXMsr_ErrorReportingType:
        *pNumber=m_ErrorReportingType;
        break;
    case PIDXMsr_TransmitSentinels:
        *pNumber=m_TransmitSentinels;
        break;
    default:
        _ASSERTE(true);
    }
    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::GetPropertyString(long PropIndex,
        BSTR* pString)
{
    switch (PropIndex)
    {
    case PIDX_CheckHealthText:
        *pString=WideString(m_CheckHealthText);
        break;
    case PIDX_ServiceObjectDescription:
        *pString=WideString(SERVICEOBJECTDESCRIPTION);
        break;
    case PIDX_DeviceDescription:
        *pString=WideString(DEVICEDESCRIPTION);
        break;
    case PIDX_DeviceName:
        *pString=WideString(DEVICENAME);
        break;
    case PIDXMsr_Track1Data:
        WaitForSingleObject(IORWMutex,INFINITE);
        *pString=WideString(t_Track1DataMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Track2Data:
        WaitForSingleObject(IORWMutex,INFINITE); // fix get wrong data
        *pString=WideString(t_Track2DataMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Track3Data:
        WaitForSingleObject(IORWMutex,INFINITE);
        *pString=WideString(t_Track3DataMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Track4Data:
        WaitForSingleObject(IORWMutex,INFINITE);
        *pString=WideString(t_Track4DataMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_AccountNumber:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_AccountNumberMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_AccountNumberMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_ExpirationDate:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_ExpirationDateMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_ExpirationDateMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Title:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_TitleMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_TitleMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_FirstName:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_FirstNameMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_FirstNameMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_MiddleInitial:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_MiddleInitialMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_MiddleInitialMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Surname:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_SurnameMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_SurnameMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Suffix:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_SuffixMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_SuffixMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_ServiceCode:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_ServiceCodeMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_ServiceCodeMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Track1DiscretionaryData:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_Track1DiscretionaryDataMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_Track1DiscretionaryDataMatrix);
        ReleaseMutex(IORWMutex);
        break;
    case PIDXMsr_Track2DiscretionaryData:
        WaitForSingleObject(IORWMutex,INFINITE);
        if (t_Track2DiscretionaryDataMatrix[0]=='\0' || m_ParseDecodeData == false)
            *pString=NULL;
        else
            *pString=WideString(t_Track2DiscretionaryDataMatrix);
        ReleaseMutex(IORWMutex);
        break;
    default:
        _ASSERTE(true);
    }
    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::OpenService(BSTR DeviceClass, BSTR DeviceName,
                                      LPDISPATCH pDispatch, long* pRC)
{
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Open service start" ;
        OutputDebugString(aat.c_str());
    }
#endif

    char *EventNames[4]={"SOData",   //CODispatch[0]
                         "SODirectIO",          //1
                         "SOError",             //2
                         "SOStatusUpdate"};     //3
    int Index;
    USES_CONVERSION;
    for (Index=0;Index < 4;++Index)
    {
        OLECHAR *OLEEventName=T2OLE(EventNames[Index]);// change unicode to multi byte char
        if (pDispatch->GetIDsOfNames(IID_NULL,
                                     &OLEEventName,
                                     1,
                                     LOCALE_SYSTEM_DEFAULT,
                                     &CODispatchID[Index]) != S_OK)
        {
            m_ResultCode=OPOS_E_NOSERVICE;
            *pRC=m_ResultCode;
#ifdef debugmode
            if (isDebug==true)
            {
                aat = "OpenService Error::Service object(SO) no service!!" ;
                OutputDebugString(aat.c_str());
            }
#endif

            return S_OK;
        }
    }
    IORWMutex=CreateMutex(NULL,false,NULL);
    m_EventQueueAvailable=CreateMutex(NULL,false,NULL);
    DllDataAvailable=CreateMutex(NULL,false,NULL);
    EventThreadActive=CreateEvent(NULL,true,false,NULL);
    EventThreadTerminated=CreateEvent(NULL,true,false,NULL);
    FreezeEventsUnfrozen=CreateEvent(NULL,true,true,NULL);
    EventTimeOut = CreateEvent(NULL,true,false,NULL);
    mIORWMutex=CreateMutex(NULL,false,"SHAREDATAIORWMutex");
    TimerActive=CreateMutex(NULL,false,NULL);

    COFreezeEventsUnfrozen=CreateEvent(NULL,true,true,NULL);
    DataEventEnable=CreateEvent(NULL,true,false,NULL);
    EnableDllDataEvent=CreateEvent(NULL,true,false,NULL);  // for process dll data event thread
    DisableDllDataEvent=CreateEvent(NULL,true,false,NULL); // for process dll share memory data thread
    EnableDllDataEventTerminated=CreateEvent(NULL,true,false,NULL);
    HANDLE  hShareRegMemory;
    LPVOID  lpShareRegMemoryAddress;
    MSRRegisterData *RegData;

    hShareRegMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                      NULL,
                                      PAGE_READWRITE,
                                      0,
                                      sizeof(MSRRegisterData)+1,
                                      "MSRRegData");

    lpShareRegMemoryAddress=MapViewOfFile(hShareRegMemory,
                                          FILE_MAP_READ|FILE_MAP_WRITE,
                                          0,
                                          0,
                                          sizeof(MSRRegisterData));
    RegData=(MSRRegisterData *)lpShareRegMemoryAddress;

    bool RV;
    AnsiString MSRRegPath;
    String RegDataTemp;
    MSRRegPath = OPOSMSRSOKey + AnsiString(DeviceName);

    TRegistry *myreg=new TRegistry();
    myreg->RootKey =HKEY_LOCAL_MACHINE;
    RV=myreg->OpenKey(MSRRegPath ,false);
    if (!RV)
    {
        m_ResultCode=OPOS_E_NOSERVICE;
        *pRC=m_ResultCode;
        delete myreg;
#ifdef debugmode
        if (isDebug==true)
        {
            aat = "OpenService Error::" + MSRRegPath + " open fail!!" ;
            OutputDebugString(aat.c_str());
        }
#endif
        return S_OK;
    }
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::" + MSRRegPath + " open success" ;
        OutputDebugString(aat.c_str());
    }
#endif
    if (myreg->ValueExists("Debug"))
    {
        if (myreg->ReadInteger("Debug")==1)
        {
            isDebug = true;
            RegData->DebugMode = 1;
        }
        else
        {
            isDebug = false;
            RegData->DebugMode = 0;
        }
    }
    else
    {
        isDebug = false;
        RegData->DebugMode = 0;
    }

    if (myreg->ValueExists("LRCOnOff"))
    {
        if (myreg->ReadInteger("LRCOnOff")==1)
        {
            m_LRCCheck=true;
            RegData->LRCOnOff = 1;
        }
        else
        {
            m_LRCCheck=false;
            RegData->LRCOnOff = 0;
        }
    }
    else
        RegData->LRCOnOff=0;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::LRC = " + IntToStr(RegData->LRCOnOff) ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (myreg->ValueExists("TrackCount"))
        RegData->TrackCount=myreg->ReadInteger("TrackCount");
    else
        RegData->TrackCount = 3;

    if (myreg->ValueExists("DelayTime"))
    {
        RegData->MSRDelayTime=myreg->ReadInteger("DelayTime");
        dTime = RegData->MSRDelayTime + 100;
    }
    else
    {
        RegData->MSRDelayTime = 400;
        dTime = 500;
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::TrackCount = " + IntToStr(RegData->TrackCount) ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (!myreg->ValueExists("Track1Post"))
    {
        RegData->Track1Post = NULL;
        TErrorEvent *EEvent=new TErrorEvent();
        EEvent->EventType=OPOSERROREVENT;

        EEvent->ResultCode=OPOS_E_EXTENDED;
        EEvent->ResultCodeExtended =OPOS_EMSR_END;

        EEvent->ErrorLocus =OPOS_EL_INPUT;
        long tmpErrorResponse=0;
        tmpErrorResponse=OPOS_ER_CLEAR;
        EEvent->pErrorResponse=&tmpErrorResponse;
        WaitForSingleObject(m_EventQueueAvailable,INFINITE);
        m_EventQueue.push(EEvent);
        ReleaseMutex(m_EventQueueAvailable);
        SetEvent(EventThreadActive);
    }
    else
    {
        RegDataTemp = myreg->ReadString("Track1Post");
        RegData->Track1Post = *RegDataTemp.c_str();
    }
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Track1Post = " + RegDataTemp ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (!myreg->ValueExists("Track1Pre"))
    {
        RegData->Track1Pre = NULL;
        TErrorEvent *EEvent=new TErrorEvent();
        EEvent->EventType=OPOSERROREVENT;

        EEvent->ResultCode=OPOS_E_EXTENDED;
        EEvent->ResultCodeExtended =OPOS_EMSR_START;

        EEvent->ErrorLocus =OPOS_EL_INPUT;
        long tmpErrorResponse=0;
        tmpErrorResponse=OPOS_ER_CLEAR;
        EEvent->pErrorResponse=&tmpErrorResponse;
        WaitForSingleObject(m_EventQueueAvailable,INFINITE);
        m_EventQueue.push(EEvent);
        ReleaseMutex(m_EventQueueAvailable);
        SetEvent(EventThreadActive);

    }
    else
    {
        RegDataTemp = myreg->ReadString("Track1Pre");
        RegData->Track1Pre = *RegDataTemp.c_str();
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Track1Pre = " + RegDataTemp ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (!myreg->ValueExists("Track2Post"))
    {
        RegData->Track2Post = NULL;
        TErrorEvent *EEvent=new TErrorEvent();
        EEvent->EventType=OPOSERROREVENT;

        EEvent->ResultCode=OPOS_E_EXTENDED;
        EEvent->ResultCodeExtended =OPOS_EMSR_END;

        EEvent->ErrorLocus =OPOS_EL_INPUT;
        long tmpErrorResponse=0;
        tmpErrorResponse=OPOS_ER_CLEAR;
        EEvent->pErrorResponse=&tmpErrorResponse;
        WaitForSingleObject(m_EventQueueAvailable,INFINITE);
        m_EventQueue.push(EEvent);
        ReleaseMutex(m_EventQueueAvailable);
        SetEvent(EventThreadActive);

    }
    else
    {
        RegDataTemp = myreg->ReadString("Track2Post");
        RegData->Track2Post = *RegDataTemp.c_str();
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Track2Post = " + RegDataTemp ;
        OutputDebugString(aat.c_str());
    }
#endif


    if (!myreg->ValueExists("Track2Pre"))
    {
        RegData->Track2Pre = NULL;
        TErrorEvent *EEvent=new TErrorEvent();
        EEvent->EventType=OPOSERROREVENT;

        EEvent->ResultCode=OPOS_E_EXTENDED;
        EEvent->ResultCodeExtended =OPOS_EMSR_START;

        EEvent->ErrorLocus =OPOS_EL_INPUT;
        long tmpErrorResponse=0;
        tmpErrorResponse=OPOS_ER_CLEAR;
        EEvent->pErrorResponse=&tmpErrorResponse;
        WaitForSingleObject(m_EventQueueAvailable,INFINITE);
        m_EventQueue.push(EEvent);
        ReleaseMutex(m_EventQueueAvailable);
        SetEvent(EventThreadActive);

    }
    else
    {
        RegDataTemp = myreg->ReadString("Track2Pre");
        RegData->Track2Pre = *RegDataTemp.c_str();
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Track2Pre = " + RegDataTemp ;
        OutputDebugString(aat.c_str());
    }
#endif


    if (!myreg->ValueExists("Track3Post"))
    {
        RegData->Track3Post = NULL;
        TErrorEvent *EEvent=new TErrorEvent();
        EEvent->EventType=OPOSERROREVENT;

        EEvent->ResultCode=OPOS_E_EXTENDED;
        EEvent->ResultCodeExtended =OPOS_EMSR_END;

        EEvent->ErrorLocus =OPOS_EL_INPUT;
        long tmpErrorResponse=0;
        tmpErrorResponse=OPOS_ER_CLEAR;
        EEvent->pErrorResponse=&tmpErrorResponse;
        WaitForSingleObject(m_EventQueueAvailable,INFINITE);
        m_EventQueue.push(EEvent);
        ReleaseMutex(m_EventQueueAvailable);
        SetEvent(EventThreadActive);

    }
    else
    {
        RegDataTemp = myreg->ReadString("Track3Post");
        RegData->Track3Post = *RegDataTemp.c_str();
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Track3Post = " + RegDataTemp ;
        OutputDebugString(aat.c_str());
    }
#endif


    if (!myreg->ValueExists("Track3Pre"))
    {
        RegData->Track3Pre = NULL;
        TErrorEvent *EEvent=new TErrorEvent();
        EEvent->EventType=OPOSERROREVENT;

        EEvent->ResultCode=OPOS_E_EXTENDED;
        EEvent->ResultCodeExtended =OPOS_EMSR_START;

        EEvent->ErrorLocus =OPOS_EL_INPUT;
        long tmpErrorResponse=0;
        tmpErrorResponse=OPOS_ER_CLEAR;
        EEvent->pErrorResponse=&tmpErrorResponse;
        WaitForSingleObject(m_EventQueueAvailable,INFINITE);
        m_EventQueue.push(EEvent);
        ReleaseMutex(m_EventQueueAvailable);
        SetEvent(EventThreadActive);

    }
    else
    {
        RegDataTemp = myreg->ReadString("Track3Pre");
        RegData->Track3Pre = *RegDataTemp.c_str();
    }

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Track3Pre = " + RegDataTemp ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (m_TrackCount>=4)
    {
        if (!myreg->ValueExists("Track4Post"))
        {
            RegData->Track4Post = NULL;
            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_END;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);

        }
        else
        {
            RegDataTemp = myreg->ReadString("Track4Post");
            RegData->Track4Post = *RegDataTemp.c_str();

#ifdef debugmode
            if (isDebug==true)
            {
                aat = "OpenService Status::Track4Post = " + RegDataTemp ;
                OutputDebugString(aat.c_str());
            }
#endif
        }

        if (!myreg->ValueExists("Track4Pre"))
        {
            RegData->Track4Pre = NULL;
            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_START;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);

        }
        else
        {
            RegDataTemp = myreg->ReadString("Track4Pre");
            RegData->Track4Pre = *RegDataTemp.c_str();

#ifdef debugmode
            if (isDebug==true)
            {
                aat = "OpenService Status::Track4Pre = " + RegDataTemp ;
                OutputDebugString(aat.c_str());
            }
#endif
        }
    }

    if (!myreg->ValueExists("MSRCardFormat"))
    {
        strcpy(RegData->MSRCardFormat,"ISO");
    }
    else
    {
        RegDataTemp = myreg->ReadString("MSRCardFormat");
        strcpy(RegData->MSRCardFormat,RegDataTemp.c_str());

#ifdef debugmode
        if (isDebug==true)
        {
            aat = "OpenService Status::MSRCardFormat = " + RegDataTemp ;
            OutputDebugString(aat.c_str());
        }
#endif
    }

    strcpy(RegData->MSRInterface,"PS2");
    RegDataTemp = "PS2";

   
    RegData->ScanCodeOnOff=0;

    if (!myreg->ValueExists("Terminator"))
    {
        RegData->MSRTerminator[0]=0;
        RegData->MSRTerminator[1]=0;
    }
    else
    {
        DWORD dwBuf=myreg->GetDataSize("Terminator");
        myreg->ReadBinaryData("Terminator", RegData->MSRTerminator, dwBuf);
    }


    
        if (!myreg->ValueExists("Track1PHex"))
        {

            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;
            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_START;
            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);
            RegData->MSRTrack1PreHex[0]=0x08;
            RegData->MSRTrack1PreHex[1]=0x37;
        }
        else
        {
            DWORD dwBuf=myreg->GetDataSize("Track1PHex");
            myreg->ReadBinaryData("Track1PHex", RegData->MSRTrack1PreHex, dwBuf);
        }
        if (!myreg->ValueExists("Track2PHex"))
        {
            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_START;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);
            RegData->MSRTrack2PreHex[0]=0x08;
            RegData->MSRTrack2PreHex[1]=0x38;
        }
        else
        {
            DWORD dwBuf=myreg->GetDataSize("Track2PHex");
            myreg->ReadBinaryData("Track2PHex", RegData->MSRTrack2PreHex, dwBuf);
        }
        if (!myreg->ValueExists("Track3PHex"))
        {

            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_START;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);
            RegData->MSRTrack3PreHex[0]=0x08;
            RegData->MSRTrack3PreHex[1]=0x39;
        }
        else
        {
            DWORD dwBuf=myreg->GetDataSize("Track3PHex");
            myreg->ReadBinaryData("Track3PHex", RegData->MSRTrack3PreHex, dwBuf);
        }
        // suFix
        if (!myreg->ValueExists("Track1SHex"))
        {
            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_END;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);
            RegData->MSRTrack1SuHex[0]=0x5a;
        }
        else
        {
            DWORD dwBuf=myreg->GetDataSize("Track1SHex");
            myreg->ReadBinaryData("Track1SHex", RegData->MSRTrack1SuHex, dwBuf);
        }
        if (!myreg->ValueExists("Track2SHex"))
        {
            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_END;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);
            RegData->MSRTrack2SuHex[0]=0x5a;
        }
        else
        {
            DWORD dwBuf=myreg->GetDataSize("Track2SHex");
            myreg->ReadBinaryData("Track2SHex", RegData->MSRTrack2SuHex, dwBuf);
        }
        if (!myreg->ValueExists("Track3SHex"))
        {
            TErrorEvent *EEvent=new TErrorEvent();
            EEvent->EventType=OPOSERROREVENT;

            EEvent->ResultCode=OPOS_E_EXTENDED;
            EEvent->ResultCodeExtended =OPOS_EMSR_END;

            EEvent->ErrorLocus =OPOS_EL_INPUT;
            long tmpErrorResponse=0;
            tmpErrorResponse=OPOS_ER_CLEAR;
            EEvent->pErrorResponse=&tmpErrorResponse;
            WaitForSingleObject(m_EventQueueAvailable,INFINITE);
            m_EventQueue.push(EEvent);
            ReleaseMutex(m_EventQueueAvailable);
            SetEvent(EventThreadActive);
            RegData->MSRTrack3SuHex[0]=0x5a;
        }
        else
        {
            DWORD dwBuf=myreg->GetDataSize("Track3SHex");
            myreg->ReadBinaryData("Track3SHex", RegData->MSRTrack3SuHex, dwBuf);
        }
  
    delete myreg;
    HookOnOff=false;
    SOInstance=this;
    CODispatch=pDispatch;
    m_AutoDisable=false;
    m_BinaryConversion=OPOS_BC_NONE;
    m_CapPowerReporting=OPOS_PR_NONE;
    m_Claimed=false;
    m_DataCount=0L;
    m_DataEventEnabled=false;
    m_DeviceEnabled=false;
    m_FreezeEvents=false;
    m_ResultCode=OPOS_SUCCESS;
    m_ResultCodeExtended=0;
    m_PowerNotify=OPOS_PN_DISABLED;
    m_PowerState=OPOS_PS_UNKNOWN;
    m_State=OPOS_S_IDLE;
    m_CapISO=true;
    m_CapJISOne=false;
    m_CapJISTwo=false;
    m_CapTransmitSentinels=false;
    m_TracksToRead=MSR_TR_1_2_3;
    m_DecodeData=true;
    m_ParseDecodeData=true;
    m_ErrorReportingType=MSR_ERT_CARD;
    m_Track1Data.Empty();
    m_Track2Data.Empty();
    m_Track3Data.Empty();
    m_Track4Data.Empty();
    m_AccountNumber.Empty();
    m_ExpirationDate.Empty();
    m_Title.Empty();
    m_FirstName.Empty();
    m_MiddleInitial.Empty();
    m_Surname.Empty();
    m_Suffix.Empty();
    m_ServiceCode.Empty();
    m_Track1DiscretionaryData.Empty();
    m_Track2DiscretionaryData.Empty();
    m_TransmitSentinels=false;
    m_CheckHealthText=WideString("Not Executed");
    m_ServiceObjectDescription=WideString(SERVICEOBJECTDESCRIPTION);
    m_ServiceObjectVersion=SERVICEOBJECTVERSION;
    m_DeviceDescription=WideString(DEVICEDESCRIPTION);
    m_DeviceName=WideString(DEVICENAME);
    mGetDataCheck=0;// all no data now....

    memset(m_Track1DataMatrix,0,128);
    memset(m_Track2DataMatrix,0,128);
    memset(m_Track3DataMatrix,0,128);
    memset(m_Track4DataMatrix,0,128);
    memset(m_AccountNumberMatrix,0,128);
    memset( m_ExpirationDateMatrix,0,4); // length shold be 4
    memset( m_TitleMatrix,0,128);
    memset( m_FirstNameMatrix,0,64);
    memset( m_MiddleInitialMatrix,0,64);
    memset( m_SurnameMatrix,0,64);
    memset( m_SuffixMatrix,0,64);
    memset( m_ServiceCodeMatrix,0,10);  //length should be 3
    memset( m_Track1DiscretionaryDataMatrix,0,128);
    memset( m_Track2DiscretionaryDataMatrix,0,128);

    EventThread=new TEventThread(false);
    EventThread->Resume();
    mTimer=new TMyTimer(false);
    mTimer->Resume();

    mOTimer=new TOverTimer(false);
    mOTimer->Resume();
    Sleep(300);
    *pRC=OPOS_SUCCESS;
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "OpenService Status::Open service success" ;
        OutputDebugString(aat.c_str());
    }
#endif

    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::ReleaseDevice(long* pRC)
{
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ReleaseDevice Status::Release device start" ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (m_State==OPOS_S_CLOSED)
    {
        m_ResultCode=OPOS_E_CLOSED;
        *pRC=m_ResultCode;
#ifdef debugmode
        if (isDebug==true)
        {
            aat = "ReleaseDevice Error::Device closed!!" ;
            OutputDebugString(aat.c_str());
        }
#endif
        return S_OK;
    }
    if (m_Claimed==false)
    {
        m_ResultCode=OPOS_E_ILLEGAL;
        *pRC=m_ResultCode;
#ifdef debugmode
        if (isDebug==true)
        {
            aat = "ReleaseDevice Error::Device not claim!!" ;
            OutputDebugString(aat.c_str());
        }
#endif
        return S_OK;
    }
    HANDLE hShareMemory;
    LPVOID lpShareMemoryAddress;
    SMData *MyData;
    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   1024,
                                   "MSRSM");
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ | FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(SMData));
    MyData=(SMData *)lpShareMemoryAddress;
    MyData->ClaimedFlag =false;
    HANDLE TempRE=OpenEvent(EVENT_ALL_ACCESS,true,"MSRRE");
    SetEvent(TempRE);
    UnmapViewOfFile(lpShareMemoryAddress);
    if (m_DeviceEnabled==true)
    {
        m_DeviceEnabled=false;
    }
    WaitForSingleObject(m_EventQueueAvailable,INFINITE);
    ResetEvent(EventThreadActive);

    while (m_EventQueue.empty()==false)
    {
        delete m_EventQueue.front();
        m_EventQueue.pop();
    }
    ReleaseMutex(m_EventQueueAvailable);
    m_Claimed=false;

    if (hDllInst)
        FreeLibrary(hDllInst);

    m_ResultCode=OPOS_SUCCESS;
    *pRC=m_ResultCode;

#ifdef debugmode
    if (isDebug==true)
    {
        aat = "ReleaseDevice Status::Release device success" ;
        OutputDebugString(aat.c_str());
    }
#endif
    Sleep(300);
    return S_OK;
}

STDMETHODIMP TMSR_SOImpl::SetPropertyNumber(long PropIndex, long Number)
{
    m_ResultCode=OPOS_SUCCESS;
    switch (PropIndex)
    {
    case PIDX_AutoDisable:
        m_AutoDisable=Number;
        break;
    case PIDX_DeviceEnabled:

#ifdef debugmode
        if (isDebug==true)
        {
            aat = "DeviceEnable Status::Device enable start" ;
            OutputDebugString(aat.c_str());
        }
#endif
        if (m_Claimed == false)
        {
            m_ResultCode=OPOS_E_NOTCLAIMED;
#ifdef debugmode
            if (isDebug==true)
            {
                aat = "DeviceEnable Error::Device not claim!!" ;
                OutputDebugString(aat.c_str());
            }
#endif
        }
        else
        {
            m_DeviceEnabled=Number;
            m_ResultCode=OPOS_SUCCESS;
#ifdef debugmode
            if (isDebug==true)
            {
                aat = "DeviceEnable Status::Device enable success" ;
                OutputDebugString(aat.c_str());
            }
#endif
            if (Number)
            {
                if (!HookOnOff)
                {
                    EnableKeyboardCapture();
                    HookOnOff=true;
                    mTimer->Resume();
#ifdef debugmode
                    if (isDebug==true)
                    {
                        aat = "DeviceEnable Status::Enable Keyboard capture" ;
                        OutputDebugString(aat.c_str());
                    }
#endif
                }
            }
            else
            {
                DisableKeyboardCapture();
                HookOnOff=false;
                mTimer->Suspend();
#ifdef debugmode
                if (isDebug==true)
                {
                    aat = "DeviceEnable Status::Disable Keyboard capture" ;
                    OutputDebugString(aat.c_str());
                }
#endif
            }
        }
        break;
    case PIDX_FreezeEvents:
        m_FreezeEvents=Number;
        if (Number==false)
            SetEvent(FreezeEventsUnfrozen);
        else
            ResetEvent(FreezeEventsUnfrozen);
        break;
    case PIDX_BinaryConversion:
        switch (Number)
        {
        case OPOS_BC_NONE:
        case OPOS_BC_NIBBLE:
        case OPOS_BC_DECIMAL:
            m_BinaryConversion=Number;
            m_ResultCode=OPOS_SUCCESS;
            break;
        default:
            m_ResultCode=OPOS_E_ILLEGAL;
        }
        break;
    case PIDX_PowerNotify:
        if (m_DeviceEnabled == true)
            m_ResultCode=OPOS_E_ILLEGAL;
        else if (m_CapPowerReporting == OPOS_PR_NONE)
            m_ResultCode=OPOS_E_ILLEGAL;
        else
            m_PowerNotify=Number;
        break;
    case PIDX_DataEventEnabled:
        if (Number==true)
            SetEvent(DataEventEnable);
        else
            ResetEvent(DataEventEnable);
        m_DataEventEnabled=Number;
        break;
    case PIDXMsr_TracksToRead:
        m_TracksToRead=Number;
        break;
    case PIDXMsr_DecodeData:
        m_DecodeData=Number;
        if (m_DecodeData==false)
            m_ParseDecodeData = false;
        break;
    case PIDXMsr_ParseDecodeData:
        m_ParseDecodeData=Number;
        if (Number==true)
            m_DecodeData = true;
        break;
    case PIDXMsr_ErrorReportingType:
        m_ErrorReportingType=Number;
        break;
    case PIDXMsr_TransmitSentinels:
        m_TransmitSentinels=Number;
        if (m_CapTransmitSentinels==false)
            m_ResultCode=OPOS_E_ILLEGAL;
        break;
    case PIDXMsr_CapISO:
        m_CapISO = Number;
        if (m_CapISO == true)
        {
            m_CapJISOne = false;
            m_CapJISTwo = false;
        }
        break;
    case PIDXMsr_CapJISOne:
        m_CapJISOne = Number;
        if (m_CapJISOne == true)
        {
            m_CapISO = true;
            m_CapJISTwo = false;
        }
        break;
    case PIDXMsr_CapJISTwo:
        m_CapJISTwo = Number;
        if (m_CapJISTwo == true)
        {
            m_CapISO = false;
            m_CapJISOne = false;
        }
        break;
    default:
        _ASSERTE(true);
    }
    return S_OK;
}

// no need to process
STDMETHODIMP TMSR_SOImpl::SetPropertyString(long PropIndex, BSTR String)
{
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "SetPropertyString Error::No support this function!!" ;
        OutputDebugString(aat.c_str());
    }
#endif
    return S_OK;
}

void __fastcall Delay(unsigned int mSec)
{
    unsigned int StartTime;
    StartTime=timeGetTime();
    do
    {
        Application->ProcessMessages();
    }
    while ((GetTickCount()-StartTime)<=mSec);
}

//********************************************************************************
__fastcall TEventThread::TEventThread(bool CreateSuspended) : TThread(CreateSuspended)
{
    FreeOnTerminate=true;
    Priority=tpNormal;
}

void __fastcall TEventThread::Execute()
{
    TOPOSEvent *Event=NULL;
    HANDLE Signals[4]={SOInstance->EventThreadActive,
                       SOInstance->FreezeEventsUnfrozen,
                       SOInstance->COFreezeEventsUnfrozen,
                       SOInstance->DataEventEnable};
    for (;;)
    {
        WaitForMultipleObjects(4,Signals,true,INFINITE);
        if (Terminated)
            break;
        WaitForSingleObject(SOInstance->m_EventQueueAvailable,INFINITE);
        Event=SOInstance->m_EventQueue.front();
        VARIANT Var,VarResult;
        VARIANT mVar[4];
        DISPPARAMS Disp={NULL,NULL,0,0};
        VariantInit(&Var);
        VariantInit(mVar);
        switch (Event->EventType)
        {

        case OPOSSTATUSUPDATEEVENT:
        {
            TStatusUpdateEvent *NowEvent=(TStatusUpdateEvent *)SOInstance->m_EventQueue.front();
            Var.vt=VT_I4;
            Var.lVal=NowEvent->Data;
            Disp.rgvarg=&Var;
            Disp.rgdispidNamedArgs =NULL;
            Disp.cArgs=1;
            Disp.cNamedArgs =0;
            CODispatch->Invoke(SOInstance->CODispatchID[3],
                               IID_NULL,
                               LOCALE_USER_DEFAULT,
                               DISPATCH_METHOD,
                               &Disp,
                               &VarResult,
                               NULL,
                               NULL);
            break;
        }
        case OPOSDIRECTIOEVENT:
        {
            TDirectIOEvent *NowEvent=(TDirectIOEvent *)SOInstance->m_EventQueue.front();
            mVar[0].vt=VT_I4;
            mVar[0].lVal=NowEvent->EventNumber;
            mVar[1].vt=VT_I4;
            mVar[1].lVal=*(NowEvent->pData);
            mVar[2].vt=VT_BSTR;
            mVar[2].bstrVal=*(NowEvent->pString);
            Disp.rgvarg=mVar;
            Disp.rgdispidNamedArgs =NULL;
            Disp.cArgs=3;
            Disp.cNamedArgs =0;
            CODispatch->Invoke(SOInstance->CODispatchID[1],
                               IID_NULL,
                               LOCALE_USER_DEFAULT,
                               DISPATCH_METHOD,
                               &Disp,
                               &VarResult,
                               NULL,
                               NULL);

            break;
        }
        case OPOSDATAEVENT:
        {
            TDataEvent *NowEvent=(TDataEvent *)SOInstance->m_EventQueue.front();
            Var.vt=VT_I4;
            Var.lVal=NowEvent->Status;
            Disp.rgvarg=&Var;
            Disp.rgdispidNamedArgs =NULL;
            Disp.cArgs=1;
            Disp.cNamedArgs =0;
            CODispatch->Invoke(SOInstance->CODispatchID[0],
                               IID_NULL,
                               LOCALE_USER_DEFAULT,
                               DISPATCH_METHOD,
                               &Disp,
                               &VarResult,
                               NULL,
                               NULL);
            break;
        }
        case OPOSERROREVENT:
        {
            TErrorEvent *NowEvent=(TErrorEvent *)SOInstance->m_EventQueue.front();
            mVar[0].vt=VT_I4;
            mVar[0].lVal=NowEvent->ResultCode;
            mVar[1].vt=VT_I4;
            mVar[1].lVal=NowEvent->ResultCodeExtended;
            mVar[2].vt=VT_I4;
            mVar[2].lVal=NowEvent->ErrorLocus;
            mVar[3].vt=VT_I4;
            mVar[3].lVal=*(NowEvent->pErrorResponse);
            Disp.rgvarg=mVar;
            Disp.rgdispidNamedArgs =NULL;
            Disp.cArgs=4;
            Disp.cNamedArgs =0;
            CODispatch->Invoke(SOInstance->CODispatchID[2],
                               IID_NULL,
                               LOCALE_USER_DEFAULT,
                               DISPATCH_METHOD,
                               &Disp,
                               &VarResult,
                               NULL,
                               NULL);
            break;
        }
        }
        SOInstance->m_EventQueue.pop();
        delete Event;
        if (SOInstance->m_EventQueue.empty() == true)
            ResetEvent(SOInstance->EventThreadActive);

        ReleaseMutex(SOInstance->m_EventQueueAvailable);
    }
    while (SOInstance->m_EventQueue.empty() == false)
    {
        delete SOInstance->m_EventQueue.front();
        SOInstance->m_EventQueue.pop();
    }
    SetEvent(SOInstance->EventThreadTerminated);
}

STDMETHODIMP TMSR_SOImpl::CloseService(long* pRC)
{
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "CloseService Status::Close service start" ;
        OutputDebugString(aat.c_str());
    }
#endif

    if (m_Claimed == true)
    {
        long TempRC=0;
        ReleaseDevice(&TempRC);
    }
    EventThread->Terminate();
    CloseHandle(EventThread);
    SetEvent(EventThreadActive);
    mTimer->Resume();
    mOTimer->Resume();
    mOTimer->Terminate();
    mTimer->Terminate();
    CloseHandle(mOTimer);
    CloseHandle(mTimer);
    SetEvent(FreezeEventsUnfrozen);
    SetEvent(COFreezeEventsUnfrozen);
    SetEvent(DataEventEnable);
    HANDLE ObjectHandles[2]={EventThreadTerminated,//DllGetTrackDataEventTerminated,
                             EnableDllDataEventTerminated};
    WaitForMultipleObjects(2,ObjectHandles,true,INFINITE);

    CloseHandle(IORWMutex);
    CloseHandle(m_EventQueueAvailable);
    CloseHandle(EventThreadActive);
    CloseHandle(EventThreadTerminated);
    CloseHandle(FreezeEventsUnfrozen);
    CloseHandle(COFreezeEventsUnfrozen);
    CloseHandle(DllDataAvailable);
    CloseHandle(DataEventEnable);
    CloseHandle(mIORWMutex);
    CloseHandle(EnableDllDataEvent);  // for process dll data event thread
    CloseHandle(DisableDllDataEvent); // for process dll share memory data thread
    CloseHandle(EnableDllDataEventTerminated);
    CloseHandle(TimerActive);

    m_State=OPOS_S_CLOSED;
    *pRC=OPOS_SUCCESS;
#ifdef debugmode
    if (isDebug==true)
    {
        aat = "CloseService Status::Close service success" ;
        OutputDebugString(aat.c_str());
    }
#endif
    return S_OK;
}

__fastcall TOverTimer::TOverTimer(bool CreateSuspended) : TThread(CreateSuspended)
{
    FreeOnTerminate=true;
    Priority=tpNormal;
}
void __fastcall TOverTimer::Execute()
{
    HANDLE hShareMemory;
    LPVOID lpShareMemoryAddress;
    MSRData *MyData;
    long mdifftime=0;

    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   2048,
                                   "MSRData");
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ|FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(MSRData));
    MyData=(MSRData *)lpShareMemoryAddress;

    while (!Terminated)
    {
        WaitForSingleObject(SOInstance->EventTimeOut,INFINITE);
        mdifftime = GetTickCount() - mOTime;
        if (mdifftime>=dTime && mdifftime>0)
        {
#ifdef debugmode
            if (isDebug==true)
            {
                sprintf(att,"TimeOut Start : %d",GetTickCount());
                OutputDebugString(att);
            }
#endif

            mdifftime=0;
            ResetEvent(SOInstance->EventTimeOut);
            SOInstance->m_DataCount++;

            wcscpy(SOInstance->t_Track1DataMatrix,SOInstance->m_Track1DataMatrix);
            wcscpy(SOInstance->t_Track2DataMatrix,SOInstance->m_Track2DataMatrix);
            wcscpy(SOInstance->t_Track3DataMatrix,SOInstance->m_Track3DataMatrix);
            wcscpy(SOInstance->t_Track4DataMatrix,SOInstance->m_Track4DataMatrix);
            wcscpy(SOInstance->t_AccountNumberMatrix,SOInstance->m_AccountNumberMatrix);
            wcscpy(SOInstance->t_ExpirationDateMatrix,SOInstance->m_ExpirationDateMatrix);// length shold be 4
            wcscpy(SOInstance->t_TitleMatrix,SOInstance->m_TitleMatrix);
            wcscpy(SOInstance->t_FirstNameMatrix,SOInstance->m_FirstNameMatrix);
            wcscpy(SOInstance->t_MiddleInitialMatrix,SOInstance->m_MiddleInitialMatrix);
            wcscpy(SOInstance->t_SurnameMatrix,SOInstance->m_SurnameMatrix);
            wcscpy(SOInstance->t_SuffixMatrix,SOInstance->m_SuffixMatrix);
            wcscpy(SOInstance->t_ServiceCodeMatrix,SOInstance->m_ServiceCodeMatrix); //length should be 3
            wcscpy(SOInstance->t_Track1DiscretionaryDataMatrix,SOInstance->m_Track1DiscretionaryDataMatrix);
            wcscpy(SOInstance->t_Track2DiscretionaryDataMatrix,SOInstance->m_Track2DiscretionaryDataMatrix);

            TDataEvent *Event=new TDataEvent();
            long tmpStatus=0;
            Event->EventType =OPOSDATAEVENT;
            tmpStatus|=MyData->MSRTrack4Len;
            tmpStatus<<=8;
            tmpStatus|=MyData->MSRTrack3Len;
            tmpStatus<<=8;
            tmpStatus|=MyData->MSRTrack2Len;
            tmpStatus<<=8;
            tmpStatus|=MyData->MSRTrack1Len;
            Event->Status =tmpStatus;
            WaitForSingleObject(SOInstance->m_EventQueueAvailable,INFINITE);
            SOInstance->m_EventQueue.push(Event);
            ReleaseMutex(SOInstance->m_EventQueueAvailable);
            SetEvent(SOInstance->EventThreadActive);

            unsigned char checkV=0x00;
            if (!SOInstance->m_Track1Data.IsEmpty())
                checkV|=0x1;
            if (!SOInstance->m_Track2Data.IsEmpty())
                checkV|=0x2;
            if (!SOInstance->m_Track3Data.IsEmpty())
                checkV|=0x4;
            if (!SOInstance->m_Track4Data.IsEmpty())
                checkV|=0x8;
            SOInstance->m_TracksToRead=checkV;

            memset(SOInstance->m_Track1DataMatrix,0,128);
            memset(SOInstance->m_Track2DataMatrix,0,128);
            memset(SOInstance->m_Track3DataMatrix,0,128);
            memset(SOInstance->m_Track4DataMatrix,0,128);
            SOInstance->m_Track1Data.Empty();
            SOInstance->m_Track2Data.Empty();
            SOInstance->m_Track3Data.Empty();
            SOInstance->m_Track4Data.Empty();
            memset(SOInstance->m_AccountNumberMatrix,0,128);
            memset(SOInstance->m_ExpirationDateMatrix,0,4);// length shold be 4
            memset(SOInstance->m_TitleMatrix,0,128);
            memset(SOInstance->m_FirstNameMatrix,0,64);
            memset(SOInstance->m_MiddleInitialMatrix,0,64);
            memset(SOInstance->m_SurnameMatrix,0,64);
            memset(SOInstance->m_SuffixMatrix,0,64);
            memset(SOInstance->m_ServiceCodeMatrix,0,10); //length should be 3
            memset(SOInstance->m_Track1DiscretionaryDataMatrix,0,128);
            memset(SOInstance->m_Track2DiscretionaryDataMatrix,0,128);
            memset(MyData->MSRTrack1Data ,0,256);
            memset(MyData->MSRTrack2Data ,0,256);
            memset(MyData->MSRTrack3Data ,0,256);
            memset(MyData->MSRTrack4Data ,0,256);

#ifdef debugmode
            if (isDebug==true)
            {
                sprintf(att,"TimeOut Over : %d",GetTickCount());
                OutputDebugString(att);
            }
#endif
        }

    }
    UnmapViewOfFile(lpShareMemoryAddress);
    CloseHandle(hShareMemory);
}

__fastcall TMyTimer::TMyTimer(bool CreateSuspended) : TThread(CreateSuspended)
{
    FreeOnTerminate=true;
    Priority=tpNormal;
}
//---------------------------------------------------------------------------
void __fastcall TMyTimer::Execute()
{
    HANDLE hShareMemory,hShareCountMemory;
    LPVOID lpShareMemoryAddress,lpShareCountMemoryAddress;
    MSRData *MyData;
    long *lCountData;
    long tmpCount;
    unsigned char LRCCheckByte;
    char mLRCError;
    char tmpstr[256];
    int checkloop;
    bool mTimeFlg = false;
    WideString tmpWideStr;
    HANDLE  hShareEndMemory;
    LPVOID  lpShareEndMemoryAddress;
    int *lEndData=0;

    hShareEndMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                      NULL,
                                      PAGE_READWRITE,
                                      0,
                                      sizeof(int)+1,
                                      "MSREndData");
    lpShareEndMemoryAddress=MapViewOfFile(hShareEndMemory,
                                          FILE_MAP_READ|FILE_MAP_WRITE,
                                          0,
                                          0,
                                          sizeof(int));
    lEndData=(int *)lpShareEndMemoryAddress;
    tEndStatus=0;

    for (;;)
    {
        Sleep(50); // release handle ; you can modify here for performance

        if (Terminated)
            break;
            
        hShareCountMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                            NULL,
                                            PAGE_READWRITE,
                                            0,
                                            sizeof(long)+1,
                                            "MSRCountData");
        lpShareCountMemoryAddress=MapViewOfFile(hShareCountMemory,
                                                FILE_MAP_READ|FILE_MAP_WRITE,
                                                0,
                                                0,
                                                sizeof(long));
        lCountData=(long *)lpShareCountMemoryAddress;
        tmpCount=*lCountData;
        tEndStatus = *lEndData;

        if (tmpCount==SOInstance->mlCountData)
        {
            UnmapViewOfFile(lpShareCountMemoryAddress);
            CloseHandle(hShareCountMemory);
            continue;
        }

        LRCCheckByte=0;
        mLRCError=0;
        SOInstance->mlCountData = tmpCount;
        UnmapViewOfFile(lpShareCountMemoryAddress);
        CloseHandle(hShareCountMemory);
        WaitForSingleObject(SOInstance->DllDataAvailable,INFINITE);
        WaitForSingleObject(SOInstance->IORWMutex,INFINITE);  //common data access mutex
        WaitForSingleObject(SOInstance->mIORWMutex,INFINITE); //mIORWMutex -> share memory access

        hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                       NULL,
                                       PAGE_READWRITE,
                                       0,
                                       2048,
                                       "MSRData");
        lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                           FILE_MAP_READ|FILE_MAP_WRITE,
                                           0,
                                           0,
                                           sizeof(MSRData));
        MyData=(MSRData *)lpShareMemoryAddress;

        {
            mTimeFlg = true;
            if (MyData->MSRTrack1Data[0]!='\0')
            {
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T1 Start : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                WaitForSingleObject(SOInstance->TimerActive,INFINITE);
                ResetEvent(SOInstance->EventTimeOut);
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T1 Reset timeout event : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                mOTime=GetTickCount();
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T1 Set now time : %d",mOTime);
                    OutputDebugString(att);
                }
#endif
                SetEvent(SOInstance->EventTimeOut);
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T1 Set timeout event : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                memset(tmpstr,0,256);
                strcpy(tmpstr,MyData->MSRTrack1Data);
                SOInstance->m_Track1Data=WideString(tmpstr);

                try
                {
                    if (SOInstance->m_Track1Data.Length())
                    {
                        if (!SOInstance->m_TransmitSentinels)
                        {
                            SOInstance->m_Track1Data=SOInstance->m_Track1Data.SubString(2,SOInstance->m_Track1Data.Length()-1);
                            SOInstance->m_Track1Data.Delete(SOInstance->m_Track1Data.Length(),1);
                        }
                        tmpWideStr=SOInstance->m_Track1Data;
                        wcscpy(SOInstance->m_Track1DataMatrix,tmpWideStr.c_bstr());
                        AnsiString tmpStr,tmpStr1,bufStr;
                        int startpos,surnamepos,spacepos,periodpos,endpos;
                        //  ^{country code}{surname}/{first name} {middle name}.{title}^
                        startpos=SOInstance->m_Track1Data.Pos(AnsiString("^"));
                        //OutputDebugString("1.start pos");
                        if (startpos >0)
                        { //  {country code}{surname}/{first name} {middle name}.{title}^.....
                            tmpStr=SOInstance->m_Track1Data.SubString(startpos+1,SOInstance->m_Track1Data.Length()-startpos);
                            endpos=tmpStr.Pos(AnsiString("^"));

                            if ((tmpStr.Length()-endpos)>0)
                            {
                                tmpStr1 = tmpStr.SubString(endpos+1,tmpStr.Length()-endpos);
                                SOInstance->m_Track1DiscretionaryData=WideString(tmpStr1);
                                tmpWideStr=SOInstance->m_Track1DiscretionaryData;
                                wcscpy(SOInstance->m_Track1DiscretionaryDataMatrix,tmpWideStr.c_bstr());
                            }
                            if (endpos<=1)
                            {
                                SOInstance->m_Track1DiscretionaryData.Empty();
                                SOInstance->m_Suffix.Empty();
                                SOInstance->m_Surname.Empty();
                                memset(SOInstance->m_Track1DiscretionaryDataMatrix,0,128);
                                memset(SOInstance->m_SuffixMatrix,0,64);
                                memset(SOInstance->m_SurnameMatrix,0,64);
                            }
                            if (endpos>1 && tmpStr.Length()>0)
                            {
                                //{country code}{surname}/{first name} {middle name}.{title}
                                tmpStr=tmpStr.SubString(1,endpos-1);
                                surnamepos = tmpStr.Pos(AnsiString("/"));
                                if (surnamepos>0)
                                {
                                    //Get surname
                                    if (surnamepos>1 && tmpStr.Length()>0)
                                    {
                                        SOInstance->m_Surname=WideString(tmpStr.SubString(1,surnamepos-1));
                                        tmpWideStr=SOInstance->m_Surname;
                                        wcscpy(SOInstance->m_SurnameMatrix,tmpWideStr.c_bstr());
                                    }
                                    //{first name} {middle name}.{title}
                                    if (tmpStr.Length()-surnamepos>0 && tmpStr.Length()>0)
                                    {
                                        tmpStr=tmpStr.SubString(surnamepos+1,tmpStr.Length()-surnamepos);
                                        tmpStr=TrimStr(tmpStr,"L");
                                        spacepos = tmpStr.Pos(AnsiString(" "));
                                        periodpos = tmpStr.Pos(AnsiString("."));
                                    }
                                    //  have {space} and {.}
                                    if (spacepos >0 && periodpos >0 && tmpStr.Length()>0)
                                    {
                                        //first name
                                        if (spacepos >1)
                                        {
                                            SOInstance->m_FirstName=WideString(tmpStr.SubString(1,spacepos-1));
                                            tmpWideStr=SOInstance->m_FirstName;
                                            wcscpy(SOInstance->m_FirstNameMatrix,tmpWideStr.c_bstr());
                                        }
                                        //middle name
                                        if ((periodpos-spacepos)>1)
                                        {
                                            SOInstance->m_MiddleInitial=WideString(tmpStr.SubString(spacepos+1,periodpos-spacepos-1));
                                            tmpWideStr=SOInstance->m_MiddleInitial;
                                            wcscpy(SOInstance->m_MiddleInitialMatrix,tmpWideStr.c_bstr());
                                        }
                                        //Title
                                        if (tmpStr.Length()>periodpos)
                                        {
                                            SOInstance->m_Title=WideString(tmpStr.SubString(periodpos+1,tmpStr.Length()-periodpos));
                                            tmpWideStr=SOInstance->m_Title;
                                            wcscpy(SOInstance->m_TitleMatrix,tmpWideStr.c_bstr());
                                        }
                                    }
                                    //  have {space} no{.}
                                    //  {first name} {middle name}
                                    if (spacepos >0 && periodpos ==0 && tmpStr.Length()>0)
                                    {
                                        //OutputDebugString("4.have {space} no{.}");
                                        //first name
                                        if (spacepos >1)
                                        {
                                            SOInstance->m_FirstName=WideString(tmpStr.SubString(1,spacepos-1));
                                            tmpWideStr=SOInstance->m_FirstName;
                                            wcscpy(SOInstance->m_FirstNameMatrix,tmpWideStr.c_bstr());
                                        }
                                        //middle name
                                        if (tmpStr.Length()>0)
                                        {
                                            SOInstance->m_MiddleInitial=WideString(tmpStr.SubString(spacepos+1,tmpStr.Length()));
                                            tmpWideStr=SOInstance->m_MiddleInitial;
                                            wcscpy(SOInstance->m_MiddleInitialMatrix,tmpWideStr.c_bstr());
                                        }
                                    }
                                    //  no{space} have{.}
                                    //  {first name}.{title}
                                    if (spacepos ==0 && periodpos >0 && tmpStr.Length()>0)
                                    {
                                        //first name
                                        if (spacepos >1)
                                        {
                                            SOInstance->m_FirstName=WideString(tmpStr.SubString(1,periodpos-1));
                                            tmpWideStr=SOInstance->m_FirstName;
                                            wcscpy(SOInstance->m_FirstNameMatrix,tmpWideStr.c_bstr());
                                        }
                                        //Title
                                        if (tmpStr.Length()>0)
                                        {
                                            SOInstance->m_Title=WideString(tmpStr.SubString(periodpos+1,tmpStr.Length()));
                                            tmpWideStr=SOInstance->m_Title;
                                            wcscpy(SOInstance->m_TitleMatrix,tmpWideStr.c_bstr());
                                        }
                                    }

                                    //  no{space} no{.}
                                    //  {first name}
                                    if (spacepos ==0 && periodpos ==0 && tmpStr.Length()>0 )
                                    {
                                        //first name
                                        SOInstance->m_FirstName=WideString(tmpStr);
                                        tmpWideStr=SOInstance->m_FirstName;
                                        wcscpy(SOInstance->m_FirstNameMatrix,tmpWideStr.c_bstr());
                                    }

                                    if (surnamepos >0)
                                    {
                                        SOInstance->m_Suffix=WideString("/" + SOInstance->m_FirstName);
                                        tmpWideStr=SOInstance->m_Suffix;
                                        wcscpy(SOInstance->m_SuffixMatrix,tmpWideStr.c_bstr());
                                    }
                                }
                                else  // no '/'
                                {
                                    surnamepos = tmpStr.Pos(AnsiString(" "));
                                    if (surnamepos>1 && tmpStr.Length()>0)
                                    {   //get surname
                                        SOInstance->m_Surname=WideString(tmpStr.SubString(1,surnamepos-1));
                                        tmpWideStr=SOInstance->m_Surname;
                                        wcscpy(SOInstance->m_SurnameMatrix,tmpWideStr.c_bstr());
                                        //get suffix
                                        SOInstance->m_Suffix=WideString(tmpStr.SubString(surnamepos+1,tmpStr.Length()));
                                        tmpWideStr=SOInstance->m_Suffix;
                                        wcscpy(SOInstance->m_SuffixMatrix,tmpWideStr.c_bstr());
                                    }
                                }
                            }
                        }
                        else
                        {
                            SOInstance->m_Track1DiscretionaryData.Empty();
                            SOInstance->m_Suffix.Empty();
                            SOInstance->m_Surname.Empty();
                            memset(SOInstance->m_Track1DiscretionaryDataMatrix,0,128);
                            memset(SOInstance->m_SuffixMatrix,0,64);
                            memset(SOInstance->m_SurnameMatrix,0,64);
                        }
                        if (SOInstance->m_LRCCheck)
                        {
                            for (checkloop=0;;checkloop++)
                            {
                                if (tmpstr[checkloop]==0)
                                    break;
                                else
                                    LRCCheckByte^=(tmpstr[checkloop] - 0x20);
                            }
                            LRCCheckByte = LRCCheckByte + 0x20;
                            if (LRCCheckByte!=MyData->MSRTrack1LRC)
                                mLRCError|=0x1; // LRC check
                        }
                        LRCCheckByte=0;
                    }
                }
                catch (...)
                { // Track1 error
                    memset(tmpstr,0,256);
                    strcpy(tmpstr,MyData->MSRTrack1Data);
                    SOInstance->m_Track1Data=WideString(tmpstr);
                }
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T1 Over : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
            }
            if (MyData->MSRTrack2Data[0]!='\0')
            {
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T2 Start : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                WaitForSingleObject(SOInstance->TimerActive,INFINITE);
                ResetEvent(SOInstance->EventTimeOut);
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T2 Reset timeout event : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                mOTime=GetTickCount();
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T2 Set now time : %d",mOTime);
                    OutputDebugString(att);
                }
#endif
                SetEvent(SOInstance->EventTimeOut);
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T2 Set timeout event : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                ReleaseMutex(SOInstance->TimerActive);
                memset(tmpstr,0,256);
                strcpy(tmpstr,MyData->MSRTrack2Data);
                SOInstance->m_Track2Data=WideString(tmpstr);

                try
                {
                    if (SOInstance->m_Track2Data.Length()) // if get data
                    {
                        if (!SOInstance->m_TransmitSentinels)
                        {
                            SOInstance->m_Track2Data=SOInstance->m_Track2Data.SubString(2,SOInstance->m_Track2Data.Length()-1);
                            SOInstance->m_Track2Data.Delete(SOInstance->m_Track2Data.Length(),1);
                        }
                        tmpWideStr=SOInstance->m_Track2Data;
                        wcscpy(SOInstance->m_Track2DataMatrix,tmpWideStr.c_bstr());
                        AnsiString tmpStr;
                        int tmppos;

                        tmppos=SOInstance->m_Track2Data.Pos(AnsiString("="));
                        if (tmppos >1)     // get descritionary data
                        {
                            tmpStr=SOInstance->m_Track2Data.SubString(tmppos+1,SOInstance->m_Track2Data.Length()-tmppos);
                            if (!tmpStr.IsEmpty())
                            {
                                SOInstance->m_Track2DiscretionaryData=WideString(tmpStr);
                                tmpWideStr=SOInstance->m_Track2DiscretionaryData;
                                wcscpy(SOInstance->m_Track2DiscretionaryDataMatrix,tmpWideStr.c_bstr());
                            }

                            tmpStr=SOInstance->m_Track2Data.SubString(1,tmppos-1);
                            if (!tmpStr.IsEmpty())
                            {
                                SOInstance->m_AccountNumber=WideString(tmpStr);
                                tmpWideStr=SOInstance->m_AccountNumber;
                                wcscpy(SOInstance->m_AccountNumberMatrix,tmpWideStr.c_bstr());
                            }
                            if (tmpStr.Length() >=4)
                            {
                                SOInstance->m_ExpirationDate=WideString(tmpStr.SubString(1,4));
                                tmpWideStr=SOInstance->m_ExpirationDate;
                                wcscpy(SOInstance->m_ExpirationDateMatrix,tmpWideStr.c_bstr());
                                if (tmpStr.Length() >=7)
                                {
                                    SOInstance->m_ServiceCode=WideString(tmpStr.SubString(5,3));
                                    tmpWideStr=SOInstance->m_ServiceCode;
                                    wcscpy(SOInstance->m_ServiceCodeMatrix,tmpWideStr.c_bstr());
                                }
                            }
                        }
                        else
                        {
                            SOInstance->m_Track2DiscretionaryData.Empty();
                            memset(SOInstance->m_Track2DiscretionaryDataMatrix,0,128);
                            SOInstance->m_AccountNumber.Empty();
                            memset(SOInstance->m_AccountNumberMatrix,0,128);
                            SOInstance->m_ExpirationDate.Empty();
                            memset(SOInstance->m_ExpirationDateMatrix,0,4);
                            SOInstance->m_ServiceCode.Empty();
                            memset(SOInstance->m_ServiceCodeMatrix,0,10);
                        }
                        if (SOInstance->m_LRCCheck)
                        {
                            for (checkloop=0;;checkloop++)
                            {
                                if (tmpstr[checkloop]==0)
                                    break;
                                else
                                    LRCCheckByte^=(tmpstr[checkloop] - 0x30);
                            }
                            LRCCheckByte = LRCCheckByte + 0x30;
                            if (LRCCheckByte!=MyData->MSRTrack2LRC)
                                mLRCError|=0x2; // LRC check
                        }
                        LRCCheckByte=0;
                    }//end check track2 data
                }
                catch (...)
                {
                    memset(tmpstr,0,256);
                    strcpy(tmpstr,MyData->MSRTrack2Data);
                    SOInstance->m_Track2Data=WideString(tmpstr);
                }
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T2 Over : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
            }// end wait for track2 data event
            if (MyData->MSRTrack3Data[0]!='\0')
            {
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T3 Start : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                WaitForSingleObject(SOInstance->TimerActive,INFINITE);
                ResetEvent(SOInstance->EventTimeOut);
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T3 Reset timeout event : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                mOTime=GetTickCount();
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T3 Set now time : %d",mOTime);
                    OutputDebugString(att);
                }
#endif
                SetEvent(SOInstance->EventTimeOut);
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T3 Set timeout event : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
                ReleaseMutex(SOInstance->TimerActive);
                memset(tmpstr,0,256);
                strcpy(tmpstr,MyData->MSRTrack3Data);
                SOInstance->m_Track3Data=WideString(tmpstr);

                if (!SOInstance->m_TransmitSentinels)
                {
                    SOInstance->m_Track3Data=SOInstance->m_Track3Data.SubString(2,SOInstance->m_Track3Data.Length()-1);
                    SOInstance->m_Track3Data.Delete(SOInstance->m_Track3Data.Length(),1);
                }
                if (SOInstance->m_Track3Data.Length())
                {
                    tmpWideStr=SOInstance->m_Track3Data;
                    wcscpy(SOInstance->m_Track3DataMatrix,tmpWideStr.c_bstr());
                    if (SOInstance->m_LRCCheck)
                    {
                        if (SOInstance->m_Track3Data.Length())
                        {
                            for (checkloop=0;;checkloop++)
                            {
                                if (tmpstr[checkloop]==0)
                                    break;
                                else
                                    LRCCheckByte^=(tmpstr[checkloop] - 0x30);
                            }
                            LRCCheckByte = LRCCheckByte + 0x30;
                            if (LRCCheckByte!=MyData->MSRTrack3LRC)
                                mLRCError|=0x4;
                        }
                    }
                    LRCCheckByte=0;
                }
#ifdef debugmode
                if (isDebug==true)
                {
                    sprintf(att,"G T3 Over : %d",GetTickCount());
                    OutputDebugString(att);
                }
#endif
            }

            if (MyData->MSRTrack4Data[0]!='\0')
            {
                SOInstance->CleanData();
                mOTime=GetTickCount();
                ResetEvent(SOInstance->EventTimeOut);
                memset(tmpstr,0,256);
                strcpy(tmpstr,MyData->MSRTrack4Data);
                SOInstance->m_Track4Data=WideString(tmpstr);

                if (!SOInstance->m_TransmitSentinels)
                {
                    SOInstance->m_Track4Data=SOInstance->m_Track4Data.SubString(2,SOInstance->m_Track4Data.Length()-1);
                    SOInstance->m_Track4Data.Delete(SOInstance->m_Track4Data.Length(),1);
                }
                if (SOInstance->m_Track4Data.Length())
                {
                    tmpWideStr=SOInstance->m_Track4Data;
                    wcscpy(SOInstance->m_Track4DataMatrix,tmpWideStr.c_bstr());
                    if (SOInstance->m_LRCCheck)
                    {
                        if (SOInstance->m_Track4Data.Length())
                        {
                            for (checkloop=0;;checkloop++)
                            {
                                if (tmpstr[checkloop]==0)
                                    break;
                                else
                                    LRCCheckByte^=tmpstr[checkloop];
                            }
                            if (LRCCheckByte!=MyData->MSRTrack4LRC)
                                mLRCError|=0x8;
                        }
                    }
                    LRCCheckByte=0;
                }
            }

            //LRC check
            if (mLRCError)
            {
                TErrorEvent *EEvent=new TErrorEvent();
                EEvent->EventType=OPOSERROREVENT;
                long ErrorResultCode=0;

                if (mLRCError & 0x8)
                {
                    EEvent->ResultCode=OPOS_E_EXTENDED;
                    SOInstance->m_ErrorReportingType=MSR_ERT_TRACK;
                    ErrorResultCode|=OPOS_EMSR_LRC;
                }
                else
                    ErrorResultCode|=0x0;
                ErrorResultCode<<=8;
                if (mLRCError & 0x4)
                {
                    EEvent->ResultCode=OPOS_E_EXTENDED;
                    SOInstance->m_ErrorReportingType=MSR_ERT_TRACK;
                    ErrorResultCode|=OPOS_EMSR_LRC;
                }
                else
                    ErrorResultCode|=0x0;
                ErrorResultCode<<=8;
                if (mLRCError & 0x2)
                {
                    EEvent->ResultCode=OPOS_E_EXTENDED;
                    SOInstance->m_ErrorReportingType=MSR_ERT_TRACK;
                    ErrorResultCode|=OPOS_EMSR_LRC;
                }
                else
                    ErrorResultCode|=0x0;
                ErrorResultCode<<=8;
                if (mLRCError & 0x1)
                {
                    EEvent->ResultCode=OPOS_E_EXTENDED;
                    SOInstance->m_ErrorReportingType=MSR_ERT_TRACK;
                    ErrorResultCode|=OPOS_EMSR_LRC;
                }
                else
                    ErrorResultCode|=0x0;
                ErrorResultCode<<=8;
                EEvent->ResultCodeExtended = ErrorResultCode;
                EEvent->ErrorLocus =OPOS_EL_INPUT_DATA;
                long tmpErrorResponse=0;
                tmpErrorResponse=OPOS_ER_CONTINUEINPUT;
                EEvent->pErrorResponse=&tmpErrorResponse;
                WaitForSingleObject(SOInstance->m_EventQueueAvailable,INFINITE);
                SOInstance->m_EventQueue.push(EEvent);
                ReleaseMutex(SOInstance->m_EventQueueAvailable);
                SetEvent(SOInstance->EventThreadActive);
            }

            tEndStatus = *lEndData;
            *lEndData=0;
        }
        //delete Event;
        UnmapViewOfFile(lpShareMemoryAddress);
        CloseHandle(hShareMemory);
        ReleaseMutex(SOInstance->DllDataAvailable);
        ReleaseMutex(SOInstance->IORWMutex);  //common data access mutex
        ReleaseMutex(SOInstance->mIORWMutex); //mIORWMutex -> share memory access
    }
    UnmapViewOfFile(lpShareEndMemoryAddress);
    CloseHandle(hShareEndMemory);
    SetEvent(SOInstance->EnableDllDataEventTerminated);
}

void TMSR_SOImpl::CleanData()
{
    t_Track1Data.Empty();
    t_Track2Data.Empty();
    t_Track3Data.Empty();
    t_Track4Data.Empty();
}

//------------------------------------------------------------------------------
AnsiString __fastcall TrimStr( AnsiString Tm , AnsiString LR )
{
    int len;
    if ( LR == "L" || LR == "B" )
    {
        len = Tm.Length();
        while ( Tm.SubString(1,1) == " " || Tm.SubString(1,2) == "")
        {
            if ( Tm.SubString(1,1) == " " )
            {
                Tm = Tm.SubString(2,len);
                len = Tm.Length();
            }
            else if ( Tm.SubString(1,2) == "" )
            {
                Tm = Tm.SubString(3,len);
                len = Tm.Length();
            }
        }
    }
    if ( LR == "R" || LR == "B" )
    {
        len = Tm.Length();
        while ( Tm.SubString(len,1) == " " || Tm.SubString(len-1,2) == "" )
        {
            if ( Tm.SubString(len,1) == " " )
            {
                len = Tm.Length();
                Tm = Tm.SubString(1,len-1);
                len = Tm.Length();
            }
            else if ( Tm.SubString(len-1,2) == "" )
            {
                len = Tm.Length();
                Tm = Tm.SubString(1,len-2);
                len = Tm.Length();
            }
        }
    }
    return Tm;
}


